/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.schedule;

import com.google.common.collect.ImmutableList;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.data.WorldAttached;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class RedstoneLinkInstruction
extends ScheduleInstruction {
    public static WorldAttached<List<CustomRedstoneActor>> customActors = new WorldAttached($ -> new ArrayList());
    public Couple<RedstoneLinkNetworkHandler.Frequency> freq = Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);

    public static void tick(class_1937 world) {
        List actors = (List)customActors.get((class_1936)world);
        Iterator actorIterator = actors.iterator();
        while (actorIterator.hasNext()) {
            CustomRedstoneActor actor = (CustomRedstoneActor)actorIterator.next();
            actor.decrement();
            if (actor.isAlive()) continue;
            Create.REDSTONE_LINK_NETWORK_HANDLER.removeFromNetwork((class_1936)world, (IRedstoneLinkable)actor);
            actorIterator.remove();
        }
    }

    public RedstoneLinkInstruction() {
        this.data.method_10569("Power", 15);
    }

    public int slotsTargeted() {
        return 2;
    }

    public boolean supportsConditions() {
        return false;
    }

    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)this.icon(), (Object)this.formatted());
    }

    private class_5250 formatted() {
        return class_2561.method_43469((String)"railways.schedule.instruction.redstone_link.power", (Object[])new Object[]{this.intData("Power")});
    }

    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect((String)(slot == 0 ? "logistics.firstFrequency" : "logistics.secondFrequency"), (Object[])new Object[0]).method_27692(class_124.field_1061));
    }

    private class_1799 icon() {
        return new class_1799((class_1935)AllBlocks.REDSTONE_LINK.get());
    }

    public class_2960 getId() {
        return Railways.asResource("redstone_link");
    }

    public class_1799 getSecondLineIcon() {
        return this.icon();
    }

    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translateDirect((String)"schedule.condition.redstone_link.frequency_powered", (Object[])new Object[0]), (Object)class_2561.method_43470((String)" #1 ").method_27692(class_124.field_1080).method_10852((class_2561)((RedstoneLinkNetworkHandler.Frequency)this.freq.getFirst()).getStack().method_7964().method_27661().method_27692(class_124.field_1062)), (Object)class_2561.method_43470((String)" #2 ").method_27692(class_124.field_1080).method_10852((class_2561)((RedstoneLinkNetworkHandler.Frequency)this.freq.getSecond()).getStack().method_7964().method_27661().method_27692(class_124.field_1062)));
    }

    public void setItem(int slot, class_1799 stack) {
        this.freq.set(slot == 0, (Object)RedstoneLinkNetworkHandler.Frequency.of((class_1799)stack));
        super.setItem(slot, stack);
    }

    public class_1799 getItem(int slot) {
        return ((RedstoneLinkNetworkHandler.Frequency)this.freq.get(slot == 0)).getStack();
    }

    protected void writeAdditional(class_2487 tag) {
        tag.method_10566("Frequency", (class_2520)this.freq.serializeEach(f -> f.getStack().method_7953(new class_2487())));
    }

    protected void readAdditional(class_2487 tag) {
        this.freq = tag.method_10573("Frequency", 9) ? Couple.deserializeEach((class_2499)tag.method_10554("Frequency", 10), c -> RedstoneLinkNetworkHandler.Frequency.of((class_1799)class_1799.method_7915((class_2487)c))) : Couple.create(() -> RedstoneLinkNetworkHandler.Frequency.EMPTY);
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        builder.addScrollInput(20, 101, (si, l) -> si.withRange(1, 16).withStepFunction(c -> c.shift ? 5 : 1).titled(class_2561.method_43471((String)"railways.schedule.instruction.redstone_link.power_edit_box")), "Power");
    }

    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, class_1937 level) {
        Train train = ((AccessorScheduleRuntime)runtime).getTrain();
        Carriage carriage = (Carriage)train.carriages.get(0);
        CustomRedstoneActor actor = new CustomRedstoneActor(carriage);
        Create.REDSTONE_LINK_NETWORK_HANDLER.addToNetwork((class_1936)level, (IRedstoneLinkable)actor);
        ((List)customActors.get((class_1936)level)).add(actor);
        runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
        ++runtime.currentEntry;
        return null;
    }

    private final class CustomRedstoneActor
    implements IRedstoneLinkable {
        private final Carriage carriage;
        private long ticks = 8L;

        private CustomRedstoneActor(Carriage carriage) {
            this.carriage = carriage;
        }

        public void decrement() {
            --this.ticks;
        }

        public int getTransmittedStrength() {
            return this.isAlive() ? RedstoneLinkInstruction.this.intData("Power") : 0;
        }

        public void setReceivedStrength(int power) {
        }

        public boolean isListening() {
            return false;
        }

        public boolean isAlive() {
            return this.ticks > 0L;
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return RedstoneLinkInstruction.this.freq;
        }

        public class_2338 getLocation() {
            return class_2338.method_49638((class_2374)this.carriage.getLeadingPoint().getPosition(this.carriage.train.graph));
        }
    }
}

